package com.tandbergtv.watchpoint.studio.ui.model;

import java.util.List;
import java.util.Map;

import org.jbpm.gd.common.model.SemanticElement;

/**
 * Interface for nodes which can send/receive messages and can send constant variables in messages.
 * 
 * @author Imran Naqvi
 * 
 */
public interface IMessageContainer extends SemanticElement, IWPVariableContainer {

	/**
	 * Sets the uid of the message.
	 * 
	 * @param uid
	 *            the uid of the message
	 */
	void setUid(String uid);
	
	/**
	 * Sets the rollback message.
	 * 
	 * @param rollbackNode
	 *            the rollback message node
	 */
	void setRollbackNode(NodeDefinition rollbackNode);
	
	/**
	 * 	Removes the rollback message node.
	 */
	void removeRollbackNode();
	
	/**
	 * Gets the uid of the message.
	 * 
	 * @return uid of the message
	 */
	String getUid();
	
	/**
	 * Gets the uid of the Rollback message.
	 * 
	 * @return uid of the Rollback message
	 */
	String getRollbackUid();
	
	/**
	 * Gets the NodeDefinition name of the Rollback message.
	 * 
	 * @return NodeDefinition name of the Rollback message
	 */
	String getRollbackDefinitionName();


	/**
	 * Gets the variables that this message sends (read variables).
	 * 
	 * @return List of outgoing variables
	 */
	List<WPVariable> getOutgoingVariables();
	
	/**
	 * Gets the variables that the Rollback message sends (read variables).
	 * 
	 * @return List of outgoing variables
	 */
	List<WPVariable> getRollbackOutgoingVariables();

	/**
	 * Gets the variables that this message receives (write variables).
	 * 
	 * @return List of incoming variables
	 */
	List<WPVariable> getIncomingVariables();
	
	/**
	 * Gets the variables that the Rollback message receives (write variables).
	 * 
	 * @return List of incoming variables
	 */
	List<WPVariable> getRollbackIncomingVariables();
	
	/**
	 * Sets the value of the variable whose name is passed to the given value.
	 * 
	 * @param varName
	 *            the name of the variable
	 * @param val
	 *            the value to set for the variable
	 */
	void setConstantValue(String varName, String val);

	/**
	 * Gets the value of the variable whose name is passed, null if the variable isn't found.
	 * 
	 * @param varName
	 * @return The Constant value for the variable; null if the variable isn't found
	 */
	String getConstantValue(String varName);

	/**
	 * Gets a map of the constants defined for this message container with the variable name as the
	 * key and variable value as the value in the map.
	 * 
	 * @return The Map of all constants
	 */
	Map<String, String> getConstants();

	/**
	 * Gets the constants that this message sends.
	 * 
	 * @return the Map of composite keys
	 */
	Map<String, String> getCompositeKeys();

	/**
	 * Sets the value of the composite key whose name is passed to the given value.
	 * 
	 * @param varName
	 *            the name of the variable
	 * @param val
	 *            the value to set for the variable
	 */
	void setCompositeKey(String varName, String val);
	
	/**
	 * Removes the composite key
	 * 
	 * @param name
	 */
	void removeCompositeKey(String name);

	/**
	 * Gets the value of the composite key whose name is passed.
	 * 
	 * @param varName
	 * @return the Composite Key for the variable
	 */
	String getCompositeKey(String varName);

	/**
	 * Updates the action handler of this message container node.
	 */
	void updateActionHandler();

	/**
	 * @return true if the message container has a attachment; false otherwise
	 */
	boolean hasAttachment();
}
