package com.tandbergtv.watchpoint.studio.ui.model;

import java.util.List;
import java.util.Map;

import com.tandbergtv.watchpoint.studio.ui.util.NameValuePair;

/**
 * Interface for nodes which can contain message sending nodes.
 * 
 * @author Imran Naqvi
 * 
 */
public interface IMessageNodeContainer extends IResourceTypeElement, IWPVariableContainer {

	/**
	 * Sets the uid of the message.
	 * 
	 * @param uid
	 *            the uid of the message
	 */
	void setUid(String uid);

	/**
	 * Gets the uid of the message.
	 * 
	 * @return uid of the message
	 */
	String getUid();

	/**
	 * Gets the constants that this message sends.
	 * 
	 * @return The Constants
	 */
	List<NameValuePair> getConstants();

	/**
	 * Gets the value of the composite key whose value is passed.
	 * 
	 * @param varName
	 * @return The value for the Composite Variable
	 */
	String getCompositeKey(String varName);

	/**
	 * Gets the constants that this message sends.
	 * 
	 * @return The list of composite keys
	 */
	Map<String, String> getCompositeKeys();

	/**
	 * Sets the value of the composite key whose name is passed to the given value.
	 * 
	 * @param varName
	 *            the name of the variable
	 * @param val
	 *            the value to set for the variable
	 */
	void setCompositeKey(String varName, String val);

	/**
	 * Gets the variables that this message sends (read variables).
	 * 
	 * @return List of outgoing variables
	 */
	List<WPVariable> getOutgoingVariables();

	/**
	 * Gets the variables that this message recieves (write variables).
	 * 
	 * @return List of incoming variables
	 */
	List<WPVariable> getIncomingVariables();

	/**
	 * Gets the value of the variable whose name is passed, null if the variable isn't found.
	 * 
	 * @param name
	 * @return The Constant value for the variable; null if the variable isn't found
	 */
	String getConstantValue(String name);
	
	/**
	 * Sets the value of the constant whose name is passed to the given value.
	 * 
	 * @param varName
	 *            the name of the variable
	 * @param val
	 *            the value to set for the variable
	 */
	void setConstantValue(String varName, String val);
}
