/**
 * SimpleTreeVisitor.java
 * Created Apr 15, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.model.tree.provider;

import org.apache.log4j.Logger;

import com.tandbergtv.watchpoint.studio.ui.model.tree.ITreeNode;
import com.tandbergtv.watchpoint.studio.ui.model.tree.ITreeNodeVisitor;

/**
 * A visitor that prints the value of the data at a node
 * 
 * @author Sahil Verma
 */
public class SimpleTreeVisitor<T> implements ITreeNodeVisitor<T> {

	private static final Logger logger = Logger.getLogger(SimpleTreeVisitor.class);
	
	/**
	 * {@inheritDoc}
	 */
	public void visit(ITreeNode<T> node) {
		logger.debug(node.getData());
	}
}
