package com.tandbergtv.watchpoint.studio.ui.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.MailElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Variable;
import org.jbpm.gd.jpdl.properties.MailElementMailInfoConfigurationCompositeCustom;

import com.tandbergtv.watchpoint.studio.ui.model.MailNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class MailElementMailInfoConfigurationComposite extends MailElementMailInfoConfigurationCompositeCustom{

	public void setMailElement(MailElement mailElement) {
		super.setMailElement(mailElement);
	}
	
	public static MailElementMailInfoConfigurationComposite create(AbstractPropertySection parentPropertySection, TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
		MailElementMailInfoConfigurationComposite result = new MailElementMailInfoConfigurationComposite();
		result.setWidgetFactory(widgetFactory);
		result.setParent(parent);
		result.setParentPropertySection(parentPropertySection);
		result.create();
		return result;
	}
	

	@Override
	protected void updateControls() {
		MailNode mailElement = (MailNode) super.getMailElement();		
		CCombo destinationCombo = super.getDestinationCombo();
		CCombo attachmentCombo = super.getAttachmentCombo();
		Text subjectText = super.getSubjectTextObject();
		Text bodyText = super.getBodyTextObject();
		
		fillCombos();
		destinationCombo.setText(mailElement.getTo() == null ? "" : mailElement.getTo());
		attachmentCombo.setText(mailElement.getAttachment() == null ? "" : mailElement.getAttachment());
		subjectText.setText(getSubjectText());
		bodyText.setText(getBodyText());
	}

	@Override
	protected void updateAttachment() {
		MailNode mailElement = (MailNode) super.getMailElement();	
		String str = super.getAttachmentCombo().getText();
		mailElement.setAttachment(str == null ? "" : str);
	}
	@Override
	protected void fillCombos() {		
		CCombo destinationCombo = super.getDestinationCombo();
		CCombo attachmentCombo = super.getAttachmentCombo();
		AbstractPropertySection parentPropertySection = super.getParentPropertySection();
		destinationCombo.removeAll();
		NodeElementContainer elementContainer = Utility.getNodeElementContainer(parentPropertySection.getPart());

		List<? extends Variable> variables = Collections.emptyList();

		if (elementContainer instanceof WorkflowTemplate) {
			WorkflowTemplate template = (WorkflowTemplate) elementContainer;
			StartState startState = template.getStartState();
			if (startState != null && startState.getTask() != null) {
				Controller controller = startState.getTask().getController();
				variables = Arrays.asList(controller.getVariables());
			}
		} else if (elementContainer instanceof NodeDefinition) {
			NodeDefinition node = (NodeDefinition) elementContainer;
			variables = node.getVariables();
		}
		
		Collections.sort(variables, new Comparator<Variable>() {
			@Override
			public int compare(Variable var1, Variable var2) {
				String var1name = "";
				if (var1.getName() != null) {
					var1name = var1.getName();
				}
				String var2name = "";
				if (var2.getName() != null) {
					var2name = var2.getName();
				}
				return var1name.compareTo(var2name);
			}
		});
		
		destinationCombo.add("");
		attachmentCombo.add("");
		for (Variable element : variables) {
			WPVariable var = (WPVariable) element;
			String varType = var.getType();
			DataType type = DataType.STRING;
			if (varType != null && !varType.trim().isEmpty()) {
				type = DataType.valueOf(varType);
			}
			if (type == DataType.STRING || type == DataType.LIST) {
				destinationCombo.add(var.getName());
				attachmentCombo.add(var.getName());
			}
		}
	}
}
