package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableColumn;

import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public abstract class WPLabelProvider extends OwnerDrawLabelProvider implements ITableLabelProvider {

    public static final String CHECKED_IMAGE = "checked.gif";
    public static final String UNCHECKED_IMAGE = "unchecked.gif";
    protected static ImageRegistry imageRegistry = new ImageRegistry();
    protected TableColumn[] columns;

    /**
     * Note: An image registry owns all of the image objects registered with it,
     * and automatically disposes of them the SWT Display is disposed.
     */
    static {
        imageRegistry.put(CHECKED_IMAGE, Utility.getImageDescriptor(CHECKED_IMAGE));
        imageRegistry.put(UNCHECKED_IMAGE, Utility.getImageDescriptor(UNCHECKED_IMAGE));
    }
    
    /**
     * Returns the image with the given key, or <code>null</code> if not found.
     */
    protected Image getCheckImage(boolean isSelected) {
        String key = isSelected ? CHECKED_IMAGE : UNCHECKED_IMAGE;
        return imageRegistry.get(key);
    }

    protected Image getImage(String fieldDecorationId) {
        FieldDecoration dec = FieldDecorationRegistry.getDefault().getFieldDecoration(fieldDecorationId);
        return dec.getImage();
    }

    @Override
    protected void measure(Event event, Object element) {
    }

    @Override
    protected void paint(Event event, Object element) {
        Rectangle bounds = event.getBounds();
        event.gc.drawImage(getColumnImage(element, event.index), bounds.x + ((columns[getColumnIndex(event)].getWidth() - 20) / 2), bounds.y + 1);
    }

    /**
     * Standard implementation considering the 3rd column to have the checked icon 
     */
    protected int getColumnIndex(Event event) {
        return event.index - 2;
    }
}