package com.tandbergtv.watchpoint.studio.ui.properties.nodedefinition;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.TableItem;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

public class NodeDefinitionVariablesCellModifier implements ICellModifier {

    private TableViewer tableViewer;
    private String[] columnTitles;

    public NodeDefinitionVariablesCellModifier(TableViewer tableViewer, String[] columnTitles) {
        this.tableViewer = tableViewer;
        this.columnTitles = columnTitles;
    }

    @Override
    public boolean canModify(Object element, String property) {
        if (property.equals(columnTitles[1])) {
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(Object element, String property) {
        WPVariable variable = (WPVariable) element;

        if (property.equals(columnTitles[0])) {
            return variable.getMappedName();

        } else if (property.equals(columnTitles[1])) {
            String newValue = variable.getName() != null ? variable.getName() : "";
            ((CCombo) tableViewer.getCellEditors()[1].getControl()).setText(newValue);
            return newValue;

        } else if (property.equals(columnTitles[2])) {
            return variable.isAttachment();

        } else if (property.equals(columnTitles[3])) {
            return variable.getType();
        }

        return variable.isCompositeKey();
    }

    @Override
    public void modify(Object element, String property, Object value) {
        WPVariable variable = (WPVariable) ((TableItem) element).getData();

        CellEditor cellEditor = tableViewer.getCellEditors()[1];
        if (property.equals(columnTitles[1])) {
            variable.setName((String) ((CCombo) cellEditor.getControl()).getText());
            ((CCombo) cellEditor.getControl()).setText("");

            if (variable.isCompositeKey()) {
                NodeDefinition nodeDefinition = (NodeDefinition) tableViewer.getInput();
                nodeDefinition.setCompositeKey(variable.getMappedName(), variable.getName());
            }
        }

        tableViewer.update(variable, new String[] { property });
    }
}
