/**
 * IDiffCalculator.java
 * Created Apr 15, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync;

import org.eclipse.core.runtime.IProgressMonitor;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.ui.model.tree.ITree;

/**
 * Calculates differences between two model objects
 * 
 * @author Sahil Verma
 */
public interface IDiffCalculator {
	
	/**
	 * Compares the models and produces a tree of differences
	 * 
	 * @param dto1
	 * @param dto2
	 * @return
	 */
	ITree<IDiff> compare(IWatchPointDTO dto1, IWatchPointDTO dto2, IProgressMonitor monitor);
}
