package com.tandbergtv.watchpoint.studio.ui.util;

/**
 * @author Raj Prakash
 *
 */
public class UIValidator {
	public enum Validation { TRIMMED, NOT_BLANK, ALPHA_NUMERIC, MAX_STRING_LENGTH, SLASH_BACK_SLASH }
	
	public static String validateValue(String propertyName, String propertyValue, Validation... validations) {
		if(validations != null && validations.length > 0) {
			for(Validation validation : validations) {
				switch(validation) {
					case NOT_BLANK:
						if(propertyValue.length() == 0)
							return propertyName + " cannot be empty.";
						break;
					case TRIMMED:
						if (propertyValue.length() != propertyValue.trim().length())
							return propertyName + " is not valid. " + propertyName + " must not start or end with a blank.";
						break;
					case ALPHA_NUMERIC:
						for(char ch : propertyValue.toCharArray())
							if(!Character.isLetterOrDigit(ch))
								return propertyName + " is not valid. " + propertyName + " must contain only alpha numeric characters.";
						break;
					case MAX_STRING_LENGTH:
						if (propertyValue.length() > 50)
							return propertyName + " is not valid. " + propertyName + " cannot exceed 50 characters.";
						break;
					case SLASH_BACK_SLASH:
						for(char ch : propertyValue.toCharArray())
							if(ch == '/' || ch == '\\')
								return propertyName + " is not valid. " + propertyName + " cannot contain \\ or / .";
						break;
				}
			}
		}
		return null;
	}

}
