package com.tandbergtv.watchpoint.studio.util;

import java.util.HashSet;
import java.util.Set;

import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.model.Delegation;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.ProcessDefinition;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.SuperState;
import org.jbpm.gd.jpdl.model.Swimlane;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.Timer;
import org.jbpm.gd.jpdl.model.TimerContainer;

import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;

/**
 * 		Imported from the JBPM's source: org.jbpm.gd.jpdl.util.JavaClassNameCollector with slight changes.
 * 
 * @author efrasio
 *
 */
public class JavaClassNameCollector {
	
	
	public static Set<String> getJavaClassNames(ProcessDefinition processDefinition) {
		HashSet<String> result = new HashSet<String>();
		addJavaClassNames(result, processDefinition.getActionElements());
		addJavaClassNames(result, processDefinition.getEvents());
		addJavaClassNames(result, processDefinition.getExceptionHandlers());
		addJavaClassNames(result, processDefinition.getNodeElements());
		addJavaClassNames(result, processDefinition.getStartState());
		addJavaClassNames(result, processDefinition.getSwimlanes());
		addJavaClassNames(result, processDefinition.getTasks());
		return result;
	}
	
	private static void addJavaClassNames(Set<String> result, ActionElement[] actionElements) {
		for (int i = 0; i < actionElements.length; i++) {
			if (actionElements[i] instanceof Action) {
				Action action = (Action)actionElements[i];
				addJavaClassNames(result, action);
			}
			if (actionElements[i] instanceof CreateTimer) {
				addJavaClassNames(result, ((CreateTimer)actionElements[i]).getAction());
			}
		}
	}
	
	private static void addJavaClassNames(Set<String> result, Action action) {
		if (action != null && action.getClassName() != null) {
			result.add(action.getClassName());
		}
	}
	
	private static void addJavaClassNames(Set<String> result, Event[] events) {
		for (int i = 0; i < events.length; i++) {
			addJavaClassNames(result, events[i].getActionElements());
		}
	}
	
	private static void addJavaClassNames(Set<String> result, ExceptionHandler[] exceptionHandlers) {
		for (int i = 0; i < exceptionHandlers.length; i++) {
			addJavaClassNames(result, exceptionHandlers[i].getActionElements());
		}
	}
	
	private static void addJavaClassNames(Set<String> result, NodeElement[] nodeElements) {
		for (int i = 0; i < nodeElements.length; i++) {
			addJavaClassNames(result, nodeElements[i].getEvents());
			addJavaClassNames(result, nodeElements[i].getExceptionHandlers());
			addJavaClassNames(result, nodeElements[i].getTransitions());
			if (nodeElements[i] instanceof TimerContainer) {
				addJavaClassNames(result, ((TimerContainer)nodeElements[i]).getTimers());
			}
			if (nodeElements[i] instanceof AutomaticTaskNode) {
				addJavaClassNames(result, ((AutomaticTaskNode)nodeElements[i]).getAction());
			}
			if (nodeElements[i] instanceof SuperState) {
				SuperState superState = (SuperState)nodeElements[i];
				addJavaClassNames(result, superState.getNodeElements());
			}
		}
	}
	
	private static void addJavaClassNames(Set<String> result, StartState startState) {
		if (startState == null) return;
		addJavaClassNames(result, startState.getEvents());
		addJavaClassNames(result, startState.getExceptionHandlers());
		addJavaClassNames(result, startState.getTransitions());
	}
	
	private static void addJavaClassNames(Set<String> result, Swimlane[] swimlanes) {
		for (int i = 0; i <swimlanes.length; i++) {
			addJavaClassName(result, swimlanes[i].getAssignment());
		}
	}
	
	private static void addJavaClassNames(Set<String> result, Task[] tasks) {
		for (int i = 0; i < tasks.length; i++) {
			addJavaClassName(result, tasks[i].getAssignment());
			addJavaClassNames(result, tasks[i].getEvents());
			addJavaClassNames(result, tasks[i].getTimers());
			addJavaClassName(result, tasks[i].getController());
		}
	}
	
	private static void addJavaClassNames(Set<String> result, Timer[] timers) {
		for (int i = 0; i < timers.length; i++) {
			if (timers[i].getAction() != null) {
				Action action = timers[i].getAction();
				if (action.getClassName() != null) {
					result.add(action.getClassName());
				}
			}
		}
	}
	
	private static void addJavaClassName(Set<String> result, Delegation delegation) {
		if (delegation != null && delegation.getClassName() != null) {
			result.add(delegation.getClassName());
		}
	}
	
}
