package com.tandbergtv.watchpoint.studio.util;

import static com.tandbergtv.watchpoint.studio.ui.wizard.RTPConstants.STUDIO_PREFERENCES_NODE;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/**
 * Utility class used to handle operations on the resource type project preferences.<p>
 * This class shall be used to store key/value pairs in the project and also to get this
 * values.
 * @author Patrik Araujo
 *
 */
public class ProjectPreferencesUtil {
	
	/**
	 * Add a preference property (key/value) to the project.
	 * @param project The project used to save the property
	 * @param key The key name of the property
	 * @param value The value to be stored
	 * @throws BackingStoreException
	 */
	public static void addProjectPreference(IProject project, String key, String value) throws BackingStoreException{
		IScopeContext projectScope = new ProjectScope(project);
		Preferences projectNode = projectScope.getNode(STUDIO_PREFERENCES_NODE);
		projectNode.put(key, value);
		projectNode.flush();
	}
	
	/**
	 * Returns the value associated with the specified key in this node. 
	 * Returns the specified default if there is no value associated with the key, 
	 * or the backing store is inaccessible.
	 * @param project The project used to get the property
	 * @param key The key name of the property
	 * @param defaultValue The value to be returned if this node has no value associated with key 
	 * or the backing store is inaccessible.
	 * @return The value associated with key, or defaultValue if no value is associated with key.
	 */
	public static String getProjectPreference(IProject project, String key, String defaultValue){
		IScopeContext projectScope = new ProjectScope(project);
		Preferences projectNode = projectScope.getNode(STUDIO_PREFERENCES_NODE);
		return projectNode.get(key, defaultValue);
	}
	

}
