/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.core;

import com.tandbergtv.watchpoint.studio.debugger.core.DataType;
import com.tandbergtv.watchpoint.studio.debugger.core.VariableAccess2;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.xml.sax.InputSource;

public class JpdlXmlReader2
extends JpdlXmlReader {
    private static final long serialVersionUID = -1967585018835597672L;
    protected Collection<JpdlXmlReader2> extensions;

    public JpdlXmlReader2() {
        this(null);
    }

    public JpdlXmlReader2(InputStream stream) {
        super(new InputSource(stream));
        this.unresolvedTransitionDestinations = new ArrayList();
        this.unresolvedActionReferences = new ArrayList();
        this.problems = new ArrayList();
        this.extensions = new ArrayList<JpdlXmlReader2>();
    }

    public List<?> readVariableAccesses(Element element) {
        ArrayList<VariableAccess2> variables = new ArrayList<VariableAccess2>();
        Iterator i = element.elementIterator("variable");
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.attributeValue("name");
            String access = e.attributeValue("access", "read,write,required");
            String mappedName = e.attributeValue("mapped-name");
            String type = e.attributeValue("type", DataType.STRING.toString());
            try {
                DataType datatype = DataType.valueOf(type);
                variables.add(new VariableAccess2(name, access, mappedName, datatype));
            }
            catch (IllegalArgumentException e1) {
                this.addError("Variable " + name + " has invalid type (" + type + ") - " + e1.getMessage(), e1);
            }
        }
        return variables;
    }
}

