/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.launching;

import com.tandbergtv.watchpoint.studio.debugger.WatchpointTemplateDebuggerPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class TemplateLaunchShortcut
implements ILaunchShortcut2 {
    public void launch(ISelection selection, String mode) {
        this.launch(this.getLaunchableResource(selection), mode);
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch(this.getLaunchableResource(editor), mode);
    }

    protected void launch(IResource resource, String mode) {
        IFile file = (IFile)resource;
        ILaunchConfiguration config = this.findLaunchConfiguration(file, this.getConfigurationType());
        if (config == null) {
            config = this.createConfiguration(file);
            ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)config, (String)mode);
            DebugUITools.openLaunchConfigurationDialog((Shell)WatchpointTemplateDebuggerPlugin.getActiveWorkbenchShell(), (ILaunchConfiguration)config, (String)group.getIdentifier(), null);
        } else {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfiguration createConfiguration(IFile file) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            String templateName = file.getName().substring(0, file.getName().lastIndexOf("."));
            wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(templateName));
            wc.setAttribute("com.tandberg.watchpoint.studio.template", file.getFullPath().toPortableString());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, file.getProject().getName());
            wc.setMappedResources(new IResource[]{file});
            config = wc.doSave();
        }
        catch (CoreException exception) {
            MessageDialog.openError((Shell)WatchpointTemplateDebuggerPlugin.getActiveWorkbenchShell(), (String)"Error creating launch configuration", (String)exception.getStatus().getMessage());
        }
        return config;
    }

    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType("com.tandbergtv.watchpoint.studio.debugger.launchConfigurationType.jpdl");
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected ILaunchConfiguration findLaunchConfiguration(IFile file, ILaunchConfigurationType configType) {
        List<ILaunchConfiguration> candidateConfigs = Collections.emptyList();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute("com.tandberg.watchpoint.studio.template", "").equals(file.getFullPath().toPortableString())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException configs) {
            // empty catch block
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        if (candidateCount > 1) {
            return this.chooseConfiguration(candidateConfigs);
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(WatchpointTemplateDebuggerPlugin.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("Select Template");
        dialog.setMessage("Select existing configuration:");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return null;
    }

    public IResource getLaunchableResource(ISelection selection) {
        IResource launchable = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            launchable = (IResource)ss.getFirstElement();
        }
        return launchable;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        IFile launchable = null;
        if (editorpart.getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput in = (IFileEditorInput)editorpart.getEditorInput();
            launchable = in.getFile();
        }
        return launchable;
    }
}

