/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.model;

import com.tandbergtv.watchpoint.studio.debugger.model.JpdlDebugElement;
import com.tandbergtv.watchpoint.studio.debugger.model.JpdlDebugTarget;
import com.tandbergtv.watchpoint.studio.debugger.model.JpdlThread;
import com.tandbergtv.watchpoint.studio.debugger.model.JpdlVariable;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class JpdlStackFrame
extends JpdlDebugElement
implements IStackFrame {
    private JpdlThread fThread;
    private String fName;
    private String fNodeName;
    private String fFileName;
    private int fId;
    private IVariable[] fVariables;

    public JpdlStackFrame(JpdlThread thread, String data, int id) {
        super((JpdlDebugTarget)thread.getDebugTarget());
        this.fId = id;
        this.fThread = thread;
        this.init(data);
    }

    private void init(String data) {
        String[] strings = data.split("\\|");
        String fileName = strings[0];
        this.fFileName = new Path(fileName).lastSegment();
        this.fName = strings[1];
        this.fNodeName = strings[2];
        int numVars = (strings.length - 3) / 2;
        this.fVariables = new IVariable[numVars];
        int i = 0;
        while (i < numVars) {
            this.fVariables[i] = new JpdlVariable(this, strings[i * 2 + 3], strings[i * 2 + 4]);
            ++i;
        }
        Arrays.sort(this.fVariables, new Comparator<IVariable>(){

            @Override
            public int compare(IVariable o1, IVariable o2) {
                try {
                    return o1.getName().compareTo(o2.getName());
                }
                catch (DebugException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.fVariables;
    }

    public boolean hasVariables() throws DebugException {
        return this.fVariables.length > 0;
    }

    public int getLineNumber() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public String getSourceName() {
        return this.fFileName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JpdlStackFrame) {
            JpdlStackFrame sf = (JpdlStackFrame)((Object)obj);
            try {
                return sf.getSourceName().equals(this.getSourceName()) && sf.getName().equals(this.getName()) && sf.fId == this.fId;
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getSourceName().hashCode() + this.fId;
    }

    protected int getIdentifier() {
        return this.fId;
    }

    protected String getNodeName() {
        return this.fNodeName;
    }
}

