/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.parser;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.runtime.parser.LaunchConfigurationInfo;
import com.tandbergtv.watchpoint.studio.debugger.ui.NodeSimulationConfigFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jbpm.graph.def.ProcessDefinition;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class RuntimeTemplateParser {
    public static Map<String, NodeSimulationConfig> parse(String file, ProcessDefinition template) throws Exception {
        LaunchConfigurationInfo info = RuntimeTemplateParser.parse(file);
        Map<String, NodeSimulationConfig> map = NodeSimulationConfigFactory.createFactory().getNodesForSimulation(template, (Map)info.getAttributes());
        return map;
    }

    public static Map<String, NodeSimulationConfig> parse(File dir, ProcessDefinition template) {
        long time = 0L;
        LaunchConfigurationInfo launch = null;
        for (File file : RuntimeTemplateParser.getLaunchConfigurations(dir)) {
            LaunchConfigurationInfo info = RuntimeTemplateParser.parse(file.getAbsolutePath());
            String name = RuntimeTemplateParser.getTemplateName(info);
            if (!template.getName().equals(name) || file.lastModified() <= time) continue;
            time = file.lastModified();
            launch = info;
        }
        if (launch == null) {
            throw new RuntimeException("No launch configuration for template " + template.getName());
        }
        return NodeSimulationConfigFactory.createFactory().getNodesForSimulation(template, (Map)launch.getAttributes());
    }

    private static List<File> getLaunchConfigurations(File dir) {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("launch");
            }
        });
        return Arrays.asList(files);
    }

    private static LaunchConfigurationInfo parse(String name) {
        LaunchConfigurationInfo info = new LaunchConfigurationInfo();
        try {
            FileInputStream stream = new FileInputStream(new File(name));
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            Element root = parser.parse(new InputSource(stream)).getDocumentElement();
            info.initializeFromXML(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return info;
    }

    private static String getTemplateName(LaunchConfigurationInfo info) {
        String string = info.getStringAttribute("com.tandberg.watchpoint.studio.template", null);
        if (string == null) {
            return null;
        }
        string = string.substring(string.lastIndexOf("/") + 1);
        return string.substring(0, string.indexOf("."));
    }
}

