/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.interpreterwrapper;

import com.tandbergtv.watchpoint.studio.debugger.util.Base64Encoder;
import com.tandbergtv.watchpoint.studio.interpreterwrapper.IRuntimeCommandFacade;

public class CommandProtocol {
    private IRuntimeCommandFacade runtimeFacade;

    public CommandProtocol(IRuntimeCommandFacade runtimeFacade) {
        this.runtimeFacade = runtimeFacade;
    }

    public String processCommand(String command) {
        String result = "ok";
        if (command == null) {
            return result;
        }
        String[] commandParams = command.split(" ");
        if (command.startsWith("clear")) {
            this.runtimeFacade.clear(this.deserializeNodeName(commandParams[commandParams.length - 1]));
        } else if (command.startsWith("exit")) {
            result = "bye.";
        } else if (command.startsWith("resume")) {
            this.runtimeFacade.resume();
        } else if (command.startsWith("set")) {
            this.runtimeFacade.set(this.deserializeNodeName(commandParams[commandParams.length - 1]));
        } else if (command.startsWith("suspend")) {
            this.runtimeFacade.suspend();
        } else if (command.startsWith("stack")) {
            result = this.runtimeFacade.getStack();
        } else if (command.startsWith("var")) {
            result = this.runtimeFacade.getVar(commandParams[commandParams.length - 1]);
        }
        return result;
    }

    private String deserializeNodeName(String nodeName) {
        return Base64Encoder.decode(nodeName);
    }
}

