package com.tandbergtv.watchpoint.studio.debugger.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

/**
 * A variable in a Jpdl stack frame
 */
public class JpdlVariable extends JpdlDebugElement implements IVariable {

    // name & stack frmae
    private String fName;
    private JpdlStackFrame fFrame;
    private String fType;

    /**
     * Constructs a variable contained in the given stack frame
     * with the given name.
     * 
     * @param frame owning stack frame
     * @param type variable name
     * @param name 
     */
    public JpdlVariable(JpdlStackFrame frame, String type, String name) {
        super((JpdlDebugTarget) frame.getDebugTarget());
        fFrame = frame;
        fType = type;
        fName = name;
    }

    /* (non-Javadoc)
     * @see org.eclipse.debug.core.model.IVariable#getValue()
     */
    public IValue getValue() throws DebugException {
        return ((JpdlDebugTarget) getDebugTarget()).getVariableValue(this);
    }

    /* (non-Javadoc)
     * @see org.eclipse.debug.core.model.IVariable#getName()
     */
    public String getName() throws DebugException {
        return fName;
    }

    /* (non-Javadoc)
     * @see org.eclipse.debug.core.model.IVariable#getReferenceTypeName()
     */
    public String getReferenceTypeName() throws DebugException {
        return fType;
    }

    /* (non-Javadoc)
     * @see org.eclipse.debug.core.model.IVariable#hasValueChanged()
     */
    public boolean hasValueChanged() throws DebugException {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see org.eclipse.debug.core.model.IValueModification#setValue(java.lang.String)
     */
    public void setValue(String expression) throws DebugException {
    }

    /* (non-Javadoc)
     * @see org.eclipse.debug.core.model.IValueModification#setValue(org.eclipse.debug.core.model.IValue)
     */
    public void setValue(IValue value) throws DebugException {
    }

    /* (non-Javadoc)
     * @see org.eclipse.debug.core.model.IValueModification#supportsValueModification()
     */
    public boolean supportsValueModification() {
        return false;
    }

    /* (non-Javadoc)
     * @see org.eclipse.debug.core.model.IValueModification#verifyValue(java.lang.String)
     */
    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    /* (non-Javadoc)
     * @see org.eclipse.debug.core.model.IValueModification#verifyValue(org.eclipse.debug.core.model.IValue)
     */
    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    /**
     * Returns the stack frame owning this variable.
     */
    protected JpdlStackFrame getStackFrame() {
        return fFrame;
    }
}