package com.tandbergtv.watchpoint.studio.builder;

import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.AbstractTreeViewExplorer;

/**
 * 		Builder responsible to maintain the Template object model.
 *  
 * @author <a href="francisco.neto@venturus.org.br">xfranet Francisco Bento da Silva Neto</a>
 *
 */
public class WatchpointTemplateBuilder extends IncrementalProjectBuilder {

	public static final String BUILDER_ID = "org.jbpm.gd.jpdl.templateBuilder";

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.internal.events.InternalBuilder#build(int,
	 *      java.util.Map, org.eclipse.core.runtime.IProgressMonitor)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	protected IProject[] build(int kind, Map args, IProgressMonitor monitor)
			throws CoreException {
		return null;
	}
	
	@Override
	protected void clean(IProgressMonitor monitor) throws CoreException {
		IProject project = getProject();
		new WatchpointTemplateVisitor().delete(project);
		new ResourceGroupVisitor().delete(project);
	}

	/**
	 * 	Refresh the views affected by this Builder.
	 * 
	 */
	protected void refreshViews() {
		PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {
			public void run() {
				IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
				// may be null during eclipse shutdown...
				if (dwindow != null) {
					IWorkbenchPage page = dwindow.getActivePage();
					if (page != null) {
						// Refreshes the ResourceGroup view.
						IViewPart part = page.findView(Utility.ID_RESOURCE_GROUP);
						if (part != null) {
							AbstractTreeViewExplorer.class.cast(part).refresh();
						}
					}
				}
			}
		});
	}

	protected void fullBuild(final IProgressMonitor monitor)
			throws CoreException {
		try {
			getProject().accept(new WatchpointTemplateVisitor());
		} catch (CoreException e) {
		}
	}

	protected void incrementalBuild(IResourceDelta delta,
			IProgressMonitor monitor) throws CoreException {
		// the visitor does the work.
		delta.accept(new WatchpointTemplateVisitor());
	}
	
}
