package com.tandbergtv.watchpoint.studio.builder.resolution.template;

import org.eclipse.core.resources.IResource;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * Resolution responsible for modify the variable type in the Start Node.
 * @author xpatrpe Patrik Araujo
 * 
 */
public class VariableTypeDoesNotMatchResolution extends WatchpointStudioTemplateResolution {

	public VariableTypeDoesNotMatchResolution(IResource resource, Object element, Object message) {
        super(resource, element, message);
    }

    @Override
    public String getLabel() {
        return (String) message;
    }

	@Override
	public void run() {
		try {
			WorkflowTemplate template = getTemplate();
			
			if(template == null){
				return;
			}
			String nodeDefinitionName = getElement().toString();
			
			NodeDefinition templateNode = (NodeDefinition) getNodeElementByName(template, nodeDefinitionName);
			
			String message = getMessage().toString();
			int begin = message.indexOf("'");
			int end = begin + message.substring(begin+1).indexOf("'") +1;
			String variableName = message.substring(begin+1, end);
			
			WPVariable nodeVariable = templateNode.getVariable(variableName);
			String templateVariableName = nodeVariable.getName();
			String nodeVariableType = nodeVariable.getType();
			
			Controller controller = template.getStartState().getTask().getController();
			Variable templateVariable = null;
			for (Variable variable : controller.getVariables()) {
				if(variable.getName().equals(templateVariableName)){
					templateVariable = variable;
					break;
				}
			}
			
			controller.removeVariable(templateVariable);
			((WPVariable)templateVariable).setType(nodeVariableType);
			controller.addVariable(templateVariable);
			
			saveTemplate();
		} catch (Exception e) {
			Utility.reportError("Error while removing unused variable.", e);
		}
	}
}
