/*
 * Created on Aug 23, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import javax.persistence.PersistenceException;

import com.tandbergtv.watchpoint.studio.dataaccess.ConnectionTypeDAI;
import com.tandbergtv.watchpoint.studio.dto.ConnectionType;

/**
 * The JPA Data Access Implementation for the ConnectionType entity.
 * 
 * @author Vijay Silva
 */
public class ConnectionTypePDAO extends PersistenceDAO<ConnectionType, Long> implements
		ConnectionTypeDAI
{
	/**
	 * @param persistenceContext
	 *            The Persistence Context to use for data operations.
	 */
	public ConnectionTypePDAO(JPAPersistenceContext persistenceContext)
	{
		super(ConnectionType.class, persistenceContext);
	}

	/**
	 * This operation is not supported for the Connection Type entity.
	 * 
	 * @see com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface#create(com.tandbergtv.watchpoint.studio.dto.IPersistable)
	 */
	@Override
	public ConnectionType create(ConnectionType entity)
	{
		return super.create(entity);
	}

	/**
	 * This operation is not supported for the Connection Type entity.
	 * 
	 * @see com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface#delete(java.io.Serializable)
	 */
	@Override
	public void delete(Long key)
	{
		String msg = "Cannot delete an existing Connection Type, operation not supported.";
		throw new PersistenceException(msg);
	}

	/**
	 * This operation is not supported for the Connection Type entity.
	 * 
	 * @see com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface#update(com.tandbergtv.watchpoint.studio.dto.IPersistable)
	 */
	@Override
	public ConnectionType update(ConnectionType entity)
	{
		String msg = "Cannot update an existing Connection Type, operation not supported.";
		throw new PersistenceException(msg);
	}
}
