/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.common.part.LabelGraphicalEditPart;
import org.jbpm.gd.common.policy.LabelGraphicalNodeEditPolicy;

/**
 * An extension of JBPM's LabelGraphicalEditPart that uses our own DirectEditPolicy.
 * 
 * @author Imran Naqvi
 *
 */
public class WPLabelGraphicalEditPart extends LabelGraphicalEditPart {

	public WPLabelGraphicalEditPart(NotationElement notationElement) {
		super(notationElement);
	}
	
	/**
	 * @see org.jbpm.gd.common.part.LabelGraphicalEditPart#createEditPolicies()
	 */
	@Override
	protected void createEditPolicies() {
		installEditPolicy("DirectEditPolicy", new WPDirectEditPolicy());
		installEditPolicy("GraphicalNodeEditPolciy", new LabelGraphicalNodeEditPolicy());
	}
}
