package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jbpm.gd.common.figure.NodeFigure;

/**
 * This class is a replacement for GPD's NodeFigure
 * 
 * @author beroubach
 */
public class WPNodeFigure extends NodeFigure implements IFigure {

    public WPNodeFigure(String nodeType, boolean hideName, ImageDescriptor imageDescriptor, ImageDescriptor transparentImageDescriptor) {
        super(nodeType, nodeType, hideName, imageDescriptor);
        getChildren().remove(0);
        add(new WPHeaderFigure(nodeType, hideName, imageDescriptor, transparentImageDescriptor), 0);
    }

    public void setName(String name) {
        ((WPHeaderFigure)getChildren().get(0)).setNodeName(name);
        getLayoutManager().layout(this);
    }

    public Label getNameLabel() {
        return ((WPHeaderFigure)getChildren().get(0)).getNameLabel();
    }
}