package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.swt.SWT;
import org.eclipse.ui.part.FileEditorInput;
import org.jbpm.gd.common.editor.Editor;
import org.jbpm.gd.common.editor.GraphPage;
import org.jbpm.gd.common.util.ImageHandler;

public class WatchPointTemplateGraphPage extends GraphPage {

    public WatchPointTemplateGraphPage(Editor editor) {
        super(editor);
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
    	saveImage();
    }

    /**
     * Save the template as JPEG image.
     */
    public void saveImage() {
        saveImage(SWT.IMAGE_JPEG);
    }

    /**
     * Save the template to image.
     * 
     * @param type
     *            {@link SWT#IMAGE_JPEG}, {@link SWT#IMAGE_PNG}, {@link SWT#IMAGE_BMP}
     */
    public void saveImage(int type) {
        LayerManager lm = (LayerManager) getDesignerModelViewer().getEditPartRegistry().get(LayerManager.ID);
        IFigure figure = lm.getLayer("Printable Layers");
        ImageHandler.saveImage(figure, getEditor(), getImageSavePath().toOSString(), type);
        refreshProcessFolder();
    }

    /**
     * Get the path of the image file.
     * 
     * @return
     */
    public IPath getImageSavePath() {
        IFile file = ((FileEditorInput) getEditorInput()).getFile();
        String name = file.getName();
        if (name.startsWith(".gpd.") && name.length() > 7) {
            name = name.substring(5, name.length() - 3) + "jpg";
        } else {
            name = this.getEditor().getDefaultImageFileName();
        }
        return file.getRawLocation().removeLastSegments(1).append(name);
    }

    private void refreshProcessFolder() {
        try {
            IFile file = ((FileEditorInput) getEditorInput()).getFile();
            file.getParent().refreshLocal(1, null);
        } catch (CoreException e) {
            e.printStackTrace();
        }
    }
}
