/*
 * Created on Sep 25, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.dailog;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.jface.dialogs.IInputValidator;

/**
 * Input Validator to validate the ResourceType Parameter Name
 * 
 * @author Vijay Silva
 */
public class ResourceTypeParameterNameValidator implements IInputValidator
{
	private Set<String> usedNames = new HashSet<String>();

	private String currentName = null;

	/**
	 * Constructor. Sets the current name to blank.
	 * 
	 * @param existingNames
	 *            A Set of all the existing Parameter Names the user is not allowed to use public
	 *            ResourceTypeParameterDialog(Set<String> existingNames)
	 */
	public ResourceTypeParameterNameValidator(Collection<String> existingNames)
	{
		this(existingNames, null);
	}

	/**
	 * Constructor.
	 * 
	 * @param existingNames
	 *            A Set of all the existing Parameter Names the user is not allowed to use
	 * @param currentName
	 *            The name of the current parameter being edited
	 */
	public ResourceTypeParameterNameValidator(Collection<String> existingNames, String currentName)
	{
		if (existingNames != null)
			usedNames.addAll(existingNames);

		this.currentName = currentName;
		if (currentName == null)
			currentName = "";
	}

	/**
	 * @return The Current Parameter Name
	 */
	public String getCurrentName()
	{
		return this.currentName;
	}

	/**
	 * @return The parameter names already used
	 */
	public Set<String> getUsedNames()
	{
		return this.usedNames;
	}

	/**
	 * Validates that the Parameter Name is not blank, and does not equal any of the existing
	 * parameter names if different from the current name.
	 * 
	 * @see org.eclipse.jface.dialogs.IInputValidator#isValid(java.lang.String)
	 */
	public String isValid(String name)
	{
		String errorMessage = null;

		name = (name != null) ? name.trim() : "";

		if (name.length() == 0)
		{
			errorMessage = "The Parameter Name cannot be blank.";
		}
		else if ((!name.equals(currentName)) && this.usedNames.contains(name))
		{
			errorMessage = "A Parameter with the same name already exists.";
		}

		return errorMessage;
	}
}
