/**
 * ResourceType.java
 * Created Apr 15, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.model;

import org.jbpm.gd.common.model.AbstractNamedElement;

/**
 * Resource type UI model. This model is not used in the editor, it's there just for...consistency.
 * 
 * @author Sahil Verma
 */
public class ResourceType extends AbstractNamedElement {
	
	private long id;

	/**
	 * @return the id
	 */
	public long getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(long id) {
		long oldId = this.id;
		this.id = id;
		firePropertyChange("id", oldId, id);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return getLabel() + " " + getName();
	}
}
