package com.tandbergtv.watchpoint.studio.ui.model;

import java.util.Comparator;

import org.jbpm.gd.jpdl.model.Variable;

/**
 * 		Comparator for sorting variables
 * 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class VariableComparator implements Comparator<Variable> {
	/**
	 * Enum to choose which field will be used in comparation.
	 * 
	 */
	public enum VariableComparatorField {
		NAME, MAPPED_NAME
	}
	
	protected VariableComparatorField field;

	public VariableComparator(VariableComparatorField field) {
		this.field = field;
	}
	
	@Override
	public int compare(Variable var1, Variable var2) {
		Object var1field = getValue(var1);
		String str1 = "";
		if (var1field != null) {
			str1 = var1field.toString();
		}
		String str2 = "";
		Object var2field = getValue(var2);
		if (var2field != null) {
			str2 = var2field.toString();
		}
		return str1.compareTo(str2);
	}
	
	public Object getValue(Variable var) {
		Object value = null;
		if (field == VariableComparatorField.NAME) {
			value = var.getName();
		} else if (field == VariableComparatorField.MAPPED_NAME) {
			value = var.getMappedName();
		}
		return value;
	}
	
}