/*
 * Created on Oct 29, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.common.model.NamedElement;
import org.jbpm.gd.common.model.SemanticElement;

import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * The Section displaying the Named Element's Name
 * 
 * @author Vijay Silva
 */
public class WPNamedElementSection extends AbstractPropertySection
{
	private WPNamedElementComposite namedElementComposite;

	private NamedElement namedElement;

	/**
	 * The Default Constructor
	 */
	public WPNamedElementSection()
	{
		super();
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#createControls(org.eclipse.swt.widgets.Composite,
	 *      org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage)
	 */
	public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage)
	{
		super.createControls(parent, aTabbedPropertySheetPage);

		TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
		Composite clientArea = factory.createFlatFormComposite(parent);
		this.namedElementComposite = new WPNamedElementComposite(this, clientArea, factory);
	}

	/**
	 * @see org.jbpm.gd.common.properties.AbstractPropertySection#setInput(org.eclipse.ui.IWorkbenchPart,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void setInput(IWorkbenchPart part, ISelection selection)
	{
		super.setInput(part, selection);

		if (!(selection instanceof IStructuredSelection))
			return;

		/* Can handle only one selected object, get the first selected Object in the selection */
		SemanticElement element = Utility.getSemanticElement(selection);

		NamedElement input = (element instanceof NamedElement) ? (NamedElement) element : null;
		this.setNamedElement(input);
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#refresh()
	 */
	public void refresh()
	{
		this.namedElementComposite.setNamedElement(namedElement);
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#shouldUseExtraSpace()
	 */
	@Override
	public boolean shouldUseExtraSpace()
	{
		return false;
	}

	/*
	 * Set the named element displayed in this control
	 */
	private void setNamedElement(NamedElement namedElement)
	{
		this.namedElement = namedElement;
	}
}
