/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties.nodedefinition;

import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jbpm.gd.jpdl.util.AutoResizeTableLayout;

import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.util.NameValuePair;

/**
 * The composite for viewing the constants of a message in a IMessageNodeContainer.
 * 
 * @author Imran Naqvi
 * 
 */
public class ConstantsComposite {
	
	/**
	 * Static Create method.
	 * 
	 * @param widgetFactory
	 *            Factory to create widgets
	 * @param parent
	 *            Parent composite in which to paint all controls
	 * @param columnTitles
	 *            titles of the columns to display
	 * @return instance of PKContainerConfigurationComposite
	 */
	public static ConstantsComposite create(FormToolkit widgetFactory, Composite parent,
			String[] columnTitles) {
		ConstantsComposite result = new ConstantsComposite();
		result.widgetFactory = widgetFactory;
		result.parent = parent;
		result.columnTitles = columnTitles;
		result.create();
		return result;
	}

	/**
	 * Static Create method which specifies the column titles.
	 * 
	 * @param widgetFactory
	 *            Factory to create widgets
	 * @param parent
	 *            Parent composite in which to paint all controls
	 * @return instance of PKContainerConfigurationComposite
	 */
	public static ConstantsComposite create(FormToolkit widgetFactory, Composite parent) {
		return create(widgetFactory, parent, new String[] { "Name", "Value" });
	}

	private FormToolkit widgetFactory;

	private Composite parent;

	private Label containerLabel;

	private Table constantsTable;

	private IMessageNodeContainer messageNodeContainer;

	private String[] columnTitles = null;

	private ConstantsComposite() {
	}

	/**
	 * Sets the IMessageNodeContainer whose properties are shown by this control.
	 * 
	 * @param messageNodeContainer
	 */
	public void setMessageNodeContainer(IMessageNodeContainer messageNodeContainer) {
		this.messageNodeContainer = messageNodeContainer;
		clearControls();
		if (messageNodeContainer != null) {
			updateControls();
		}
	}

	/*
	 * Clear data from all controls.
	 */
	private void clearControls() {
		constantsTable.removeAll();
	}

	/*
	 * Update data in all controls.
	 */
	private void updateControls() {
		refreshTable();
	}

	/*
	 * Creates the widgets that are included in this composite.
	 */
	private void create() {
		containerLabel = widgetFactory.createLabel(parent, "Constants :");
		constantsTable = widgetFactory.createTable(parent, SWT.V_SCROLL | SWT.H_SCROLL
				| SWT.FULL_SELECTION);
		containerLabel.setLayoutData(createMessageLabelLayoutData());
		constantsTable.setLayoutData(createConstantsTableLayoutData());
		initializeConstantsTable();
	}

	/*
	 * Initializes the constants table.
	 */
	private void initializeConstantsTable() {
		constantsTable.setHeaderVisible(true);
		constantsTable.setLinesVisible(true);
		constantsTable.setLayout(new AutoResizeTableLayout(constantsTable));
		initializeConstantsTableColumns();
	}

	/*
	 * Initializes the columns for the table of constants.
	 */
	private void initializeConstantsTableColumns() {
		TableLayout layout = (TableLayout) constantsTable.getLayout();
		TableColumn nameColumn = new TableColumn(constantsTable, SWT.LEFT);
		nameColumn.setText(columnTitles[0]);
		ColumnWeightData nameColumnData = new ColumnWeightData(15);
		nameColumnData.resizable = false;
		layout.addColumnData(nameColumnData);
		TableColumn valColumn = new TableColumn(constantsTable, SWT.LEFT);
		valColumn.setText(columnTitles[1]);
		ColumnWeightData valColumnData = new ColumnWeightData(15);
		valColumnData.resizable = false;
		layout.addColumnData(valColumnData);
	}

	private FormData createMessageLabelLayoutData() {
		FormData result = new FormData();
		result.top = new FormAttachment(0, 5);
		result.left = new FormAttachment(0, 5);
		result.right = new FormAttachment(100, -5);
		return result;
	}

	private FormData createConstantsTableLayoutData() {
		FormData result = new FormData();
		result.top = new FormAttachment(containerLabel, 5);
		result.left = new FormAttachment(0, 5);
		result.right = new FormAttachment(100, -10);
		result.width = 600;
		return result;
	}

	private void refreshTable() {
		constantsTable.removeAll();
		//TODO: Sort the constants
		for(NameValuePair pair : messageNodeContainer.getConstants()){
			TableItem constantTableItem = new TableItem(constantsTable, SWT.NONE);
			constantTableItem.setText(new String[]{pair.getName(), pair.getValue()});
		}
	}
}
