/**
 * ResourceGroupDataProvider.java
 * Created Feb 17, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.wizard.resource;

import java.util.Collection;
import java.util.List;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.external.fs.dao.DataAccessFactoryImpl;
import com.tandbergtv.watchpoint.studio.external.imports.ImportDataProvider;
import com.tandbergtv.watchpoint.studio.external.jpf.JPFContextFactory;
import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.impl.ServiceImpl;

/**
 * Looks for resource groups that can be imported from the filesystem
 * 
 * @author Sahil Verma
 */
public class ResourceGroupDataProvider implements ImportDataProvider {

	private String location;
	
	private Collection<ResourceGroup> existing;
	
	public ResourceGroupDataProvider() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	public String getImportLocation() {
		return location;
	}

	/**
	 * {@inheritDoc}
	 */
	public void setImportLocation(String location) {
		this.location = location;
	}
	/**
	 * {@inheritDoc}
	 */
	public Collection<? extends IWatchPointDTO> getItems() {
		if (this.location == null)
			throw new IllegalArgumentException("Import location must be specified");
		
		this.existing = ServiceFactory.createFactory().createResourceGroupService().getAllResourceGroups();
		
		Collection<ResourceGroup> list = getGroupsToImport();

		filter(list);
		
		return list;
	}
	
	protected void filter(Collection<ResourceGroup> list) {
	}
	
	protected ResourceGroup findExistingGroup(String name) {
		for (ResourceGroup group : this.existing) {
			if (group.getName().equals(name))
				return group;
		}
		
		return null;
	}
	
	protected Collection<ResourceGroup> getGroupsToImport() {
		IResourceGroupService service = ServiceFactory.createFactory().createResourceGroupService();
		
		((ServiceImpl) service).setDataAccessFactory(new DataAccessFactoryImpl());
		((ServiceImpl) service).setPersistenceContextFactory(new JPFContextFactory(this.location));

		List<ResourceGroup> groups = IResourceGroupService.class.cast(service).getAllResourceGroups();

		return groups;
	}
}
