/**
 * ResourceGroupImportWizard.java
 * Created Feb 17, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.wizard.resource;

import java.util.Collection;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

import com.tandbergtv.watchpoint.studio.builder.WatchpointResourceTypeNature;
import com.tandbergtv.watchpoint.studio.builder.WatchpointTemplateNature;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.ui.wizard.imports.ImportWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.imports.ImportWizardDestinationProjectPage;
import com.tandbergtv.watchpoint.studio.ui.wizard.imports.ImportWizardFirstPage;
import com.tandbergtv.watchpoint.studio.ui.wizard.imports.ImportWizardListPage;
import com.tandbergtv.watchpoint.studio.ui.wizard.template.TemplateDataProvider;

/**
 * Wizard for importing resource groups from a file system location
 * 
 * @author Sahil Verma
 */
public class ResourceGroupImportWizard extends ImportWizard {
	ImportWizardDestinationProjectPage page4;
	/**
	 * @param clazz
	 */
	public ResourceGroupImportWizard() {
		super(ResourceGroup.class, "Resource Group Plug-ins");
	}
	

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void addPages() {
		setNeedsProgressMonitor(true);
		
		page1 = new ImportWizardFirstPage("Choose Import Directory", this.clazz);
		
		/* FIXME Register providers using the extension mechanism. Also, provide a way to choose
		 * the types of import location - local repository, HTTP repository, database etc */
		page1.addProvider(ResourceType.class, new ResourceTypeDataProvider());
		page1.addProvider(ResourceGroup.class, new ResourceGroupDataProvider());
		page1.addProvider(WorkflowTemplateDTO.class, new TemplateDataProvider());
		
		addPage(page1);
		
		page2 = new ImportWizardListPage("Selection", page1, this.selection);
		
		addPage(page2);
		
		page4 = new ImportWizardDestinationProjectPage("Project", clazz);
		page4.setRequiredProjectNatures(WatchpointTemplateNature.NATURE_ID, WatchpointResourceTypeNature.NATURE_ID);
		
		addPage(page4);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public boolean performFinish() {
		page1.saveSettings(getDialogSettings());
		page2.saveSettings(getDialogSettings());
		page4.saveSettings(getDialogSettings());
		
		ResourceGroupImportService importService = new ResourceGroupImportService();
		IPath path = new Path(page4.getBaseDirectory());
		IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
		importService.importItems((Collection<ResourceGroup>) page2.getSelectedModels(), folder);
		
		return true;
	}
}
