package com.tandbergtv.watchpoint.studio.util;

public class ConvertExprUtility {

	private static String CLOSE_BRACKET = ")";

	private static final char ADD_OPERATOR = '+';

	private static final char MULTIPLY_OPERATOR = '*';

	/**
	 * Converts the Timer Expression
	 * 
	 * @param expr
	 * @return string
	 */
	public static String convertTimerExpression(String expr) {
		String newExpression = null;
		String[] operands = ValidationUtil.getOperands(expr);
		int numberOfOperands = operands.length;
		switch (numberOfOperands) {

		case 1:
			newExpression = convertExpression(operands, ' ');
			break;
		case 2:
			char operator = ValidationUtil.getOperator(expr);
			newExpression = convertExpression(operands, operator);
			break;

		default:
			break;

		}
		return newExpression;
	}

	/*
	 * Converts the Timer Expression
	 */
	private static String convertExpression(String[] operands, char operator) {

		String newExpression = null;

		if (operator == ADD_OPERATOR) {
			newExpression = buildAddExpression(operands);
		} else if (operator == MULTIPLY_OPERATOR) {
			newExpression = buildMlpyExpression(operands);
		} else {
			newExpression = buildGeneralExpression(operands);
		}
		return newExpression;
	}

	/**
	 * Converts the Decision Expression
	 * 
	 * @param expr
	 * @return String
	 */
	public static String convertDecisionExpression(String expr) {
		StringBuffer expression = new StringBuffer("#{()}");
		expression.insert(expression.lastIndexOf(CLOSE_BRACKET), expr);
		return expression.toString();
	}

	/*
	 * Checks whether the given operand is constant or not
	 */
	private static boolean isConstant(String operand) {
		for (int i = 0; i < operand.length(); i++) {
			char c = operand.charAt(i);
			if (c > 58 || c < 48)
				return false;
		}
		return true;
	}

	/*
	 * Checks whether the given operand is Duration constant or not
	 */
	private static boolean isDurationConstant(String operand) {
		if (operand.contains(":")) {
			return true;
		}
		return false;
	}

	/*
	 * Builds the Add Expression
	 */
	private static String buildAddExpression(String[] operands) {
		int index = 0;
		StringBuffer addExpr = new StringBuffer("util.addDates()");

		for (String operand : operands) {
			StringBuffer durationVariable = new StringBuffer(
					"executionContext.getVariable().toString()");
			if (isDurationConstant(operand)) {
				addExpr.insert(addExpr.lastIndexOf(CLOSE_BRACKET), "\""
						+ operand + "\"");
			} else {
				durationVariable.insert(
						durationVariable.indexOf(CLOSE_BRACKET), "\"" + operand
								+ "\"");
				addExpr.insert(addExpr.lastIndexOf(CLOSE_BRACKET),
						durationVariable);
			}
			index++;
			if (index == 1)
				addExpr.insert(addExpr.lastIndexOf(CLOSE_BRACKET), ",");
		}
		return addExpr.toString();
	}

	/*
	 * Builds the Multiply Expression
	 */
	private static String buildMlpyExpression(String[] operands) {
		int index = 0;
		StringBuffer mlpyExpr = new StringBuffer("util.multiplyDate()");
		for (String operand : operands) {
			StringBuffer integerVariable = new StringBuffer(
					"(Double.parseDouble(executionContext.getVariable().toString()))");
			StringBuffer durationVariable = new StringBuffer(
					"executionContext.getVariable().toString()");
			if (isConstant(operand)) {
				if (isDurationConstant(operand)) {
					mlpyExpr.insert(mlpyExpr.lastIndexOf(CLOSE_BRACKET), "\""
							+ operand + "\"");
				} else {
					mlpyExpr.insert(mlpyExpr.lastIndexOf(CLOSE_BRACKET),
							operand);
				}

			} else {
				if (index != 0) {
					integerVariable.insert(integerVariable
							.indexOf(CLOSE_BRACKET), "\"" + operand + "\"");
					mlpyExpr.insert(mlpyExpr.lastIndexOf(CLOSE_BRACKET),
							integerVariable);
				} else {

					durationVariable.insert(durationVariable
							.indexOf(CLOSE_BRACKET), "\"" + operand + "\"");
					mlpyExpr.insert(mlpyExpr.lastIndexOf(CLOSE_BRACKET),
							durationVariable);
				}
			}
			index++;
			if (index == 1)
				mlpyExpr.insert(mlpyExpr.lastIndexOf(CLOSE_BRACKET), ",");
		}
		return mlpyExpr.toString();
	}

	/*
	 * Builds Single Operand Expression
	 */
	private static String buildGeneralExpression(String[] operands) {
		StringBuffer variable = new StringBuffer(
				"executionContext.getVariable()");
		if (isDurationConstant(operands[0])) {
			return operands[0];
		} else {
			variable.insert(variable.indexOf(CLOSE_BRACKET), "\"" + operands[0]
					+ "\"");
			return variable.toString();
		}

	}
}
