/**
 * 
 */
package com.tandbergtv.watchpoint.studio.validation.model;

import java.util.List;

import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;

/**
 * Validation Model Object that represents a Due Date Expression.
 * 
 * @author DReddy
 * @author Vijay Silva
 */
public class DueDateExpression extends ContainerValidationContext
{
	protected IDueDateElement node;

	/**
	 * Constructor.
	 * 
	 * @param template
	 *            the workflow template that contains the Due Date node
	 * @param node
	 *            the Due Date node with the expression to validate
	 * @param variables
	 *            the list of variables that may be used in the expression
	 */
	public DueDateExpression(WorkflowTemplate template, List<WPVariable> variables,
			IDueDateElement node)
	{
		super(template, variables);
		this.node = node;
	}

	/**
	 * Constructor.
	 * 
	 * @param nodeDefinition
	 *            the node definition that contains the Due Date node
	 * @param node
	 *            the Due Date node with the expression to validate
	 * @param variables
	 *            the list of variables that may be used in the expression
	 */
	public DueDateExpression(NodeDefinition nodeDefinition, List<WPVariable> variables,
			IDueDateElement node)
	{
		super(nodeDefinition, variables);
		this.node = node;
	}

	/**
	 * Get the DueDateElement node
	 * 
	 * @return the node
	 */
	public IDueDateElement getDueDateElement()
	{
		return this.node;
	}
}
