/*
 * Created on Nov 6, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.nodedefinition;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;

/**
 * Validation Rule that ensures that the Message UID is set for a Single State Node Definition.
 * 
 * @author Vijay Silva
 */
public class MessageRequiredRule extends ValidationRule<NodeDefinition>
{
	/**
	 * Validates that the Node Definition has a Message configured if a Single State Node
	 * Definition.
	 * 
	 * @param target
	 *            The NodeDefinition to validate
	 * @return The list of validation messages
	 * @see com.tandbergtv.watchpoint.studio.validation.IValidationRule#validateRule(java.lang.Object)
	 */
	public List<ValidationMessage> validateRule(NodeDefinition target)
	{
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

		if (target.getNodeType() == NodeDefinitionType.MessageNode)
		{
			String uid = target.getUid();
			if (uid == null || uid.trim().length() == 0)
			{
				ValidationMessageAdder.getInstance().addValidationMessage(messages, target, ValidationMessageCode.NODEDEFINITION_MESSAGE_MISSING);
			}
		}

		return messages;
	}
}
