/**
 * 
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;

/**
 * Validation rule that verifies that a IDueDateElement does not have a Due Date defined.
 * 
 * @author Vijay Silva
 */
public class DueDateAbsentRule extends ValidationRule<IDueDateElement>
{
	/**
	 * Check that a IDueDateElement does not have Due Date defined.
	 * 
	 * @param target
	 *            The IDueDateElement to validate
	 * 
	 * @return The List of validation messages
	 * 
	 * @see com.tandbergtv.watchpoint.studio.validation.IValidationRule#validateRule(java.lang.Object)
	 */
	public List<ValidationMessage> validateRule(IDueDateElement target)
	{
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

		String dueDate = target.getDueDate();
		if (dueDate != null && dueDate.trim().length() > 0)
		{
			ValidationMessageAdder.getInstance().addValidationMessage(messages, target, ValidationMessageCode.NODE_DUEDATE_DEFINED);
		}

		return messages;
	}
}
