/*
 * Created on Nov 21, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition;

import java.util.Set;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

/**
 * Strategy that helps determine the list of variables that require variable mapping.
 * 
 * @author Vijay Silva
 */
public interface IRequiredVariableFinder
{
	/**
	 * Gets the set of all variable names in the Node Definition node that require a mapped
	 * variable.
	 * 
	 * @param nodeDefinition
	 *            The Node Definition containing the variables to be checked.
	 * 
	 * @return The list variable names that must be mapped.
	 */
	public Set<String> getRequiredVariableNames(NodeDefinition nodeDefinition);
}
