/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.ui;

import com.tandbergtv.watchpoint.studio.debugger.launching.TemplateLauncherConstants;
import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationData;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.MailNode;
import com.tandbergtv.watchpoint.studio.ui.model.ManualTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.Loop;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.Node;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.ProcessState;
import org.jbpm.gd.jpdl.model.SuperState;
import org.jbpm.graph.def.ProcessDefinition;

public class NodeSimulationConfigFactory {
    private Set<Class<?>> simullableNodes;
    private static NodeSimulationConfigFactory instance;

    private NodeSimulationConfigFactory() {
    }

    protected static Map<String, Map> createSimulationDataMapPerNode(Map globalAttributes) {
        HashMap<String, Map> attributesPerNode = new HashMap<String, Map>();
        for (Object keyObj : globalAttributes.keySet()) {
            int simulationDataIndex;
            String key = keyObj.toString();
            if (!key.startsWith("com.tandberg.watchpoint.studio.nodes") || (simulationDataIndex = key.indexOf("simulation.data")) <= 0) continue;
            String nodeName = key.substring("com.tandberg.watchpoint.studio.nodes".length() + 1, simulationDataIndex - 1);
            HashMap nodeAttributes = (HashMap)attributesPerNode.get(nodeName);
            if (nodeAttributes == null) {
                nodeAttributes = new HashMap();
            }
            String attributeName = key.substring(simulationDataIndex + "simulation.data".length() + 1, key.length());
            nodeAttributes.put(attributeName, globalAttributes.get(keyObj));
            attributesPerNode.put(nodeName, nodeAttributes);
        }
        return attributesPerNode;
    }

    public Set<Class<?>> getSimullableNodes() {
        if (this.simullableNodes == null) {
            this.simullableNodes = new HashSet();
            this.simullableNodes.add(Node.class);
            this.simullableNodes.add(ProcessState.class);
            this.simullableNodes.add(SuperState.class);
            this.simullableNodes.add(Decision.class);
            this.simullableNodes.add(NodeDefinition.class);
            this.simullableNodes.add(AutomaticTaskNode.class);
            this.simullableNodes.add(ManualTaskNode.class);
            this.simullableNodes.add(LoopNode.class);
            this.simullableNodes.add(MailNode.class);
        }
        return this.simullableNodes;
    }

    public static NodeSimulationConfigFactory createFactory() {
        if (instance == null) {
            instance = new NodeSimulationConfigFactory();
        }
        return instance;
    }

    public Map<String, NodeSimulationConfig> getNodesForSimulation(WorkflowTemplate template, Map globalAttributes) {
        HashMap<String, NodeSimulationConfig> simulationConfigMap = new HashMap<String, NodeSimulationConfig>();
        Map<String, Map> attributesPerNode = NodeSimulationConfigFactory.createSimulationDataMapPerNode(globalAttributes);
        this.loadNodeSimulationConfig((NodeElementContainer)template, attributesPerNode, globalAttributes, simulationConfigMap);
        return simulationConfigMap;
    }

    public void loadNodeSimulationConfig(NodeElementContainer container, Map<String, Map> attributesPerNode, Map globalAttributes, Map<String, NodeSimulationConfig> simulationConfigMap) {
        NodeElement[] nodeElements;
        NodeElement[] nodeElementArray = nodeElements = container.getNodeElements();
        int n = nodeElements.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement nodeElement = nodeElementArray[n2];
            if (this.getSimullableNodes().contains(nodeElement.getClass())) {
                NodeSimulationConfig config = this.getNodeForSimulation(nodeElement, globalAttributes, attributesPerNode);
                simulationConfigMap.put(nodeElement.getName(), config);
                if (nodeElement instanceof LoopNode) {
                    this.loadNodeSimulationConfig((NodeElementContainer)((LoopNode)nodeElement), attributesPerNode, globalAttributes, simulationConfigMap);
                }
            }
            ++n2;
        }
    }

    public NodeSimulationConfig getNodeForSimulation(NodeElement nodeElement, Map globalAttributes, Map<String, Map> attributesPerNode) {
        NodeSimulationConfig config = this.getNodeForSimulation(nodeElement.getName(), globalAttributes, attributesPerNode);
        config.setNodeElement(nodeElement);
        if (config.getSimulationType() == null) {
            config.setSimulationType(this.getDefaultSimulationTypeForNode(nodeElement));
        }
        return config;
    }

    public NodeSimulationConfig getNodeForSimulation(String nodeName, Map globalAttributes, Map<String, Map> attributesPerNode) {
        if (attributesPerNode == null) {
            attributesPerNode = NodeSimulationConfigFactory.createSimulationDataMapPerNode(globalAttributes);
        }
        NodeSimulationConfig config = new NodeSimulationConfig();
        SimulationData simulationData = new SimulationData(attributesPerNode.get(nodeName));
        config.setTemplateNodeName(nodeName);
        config.setSimulationData(simulationData);
        config.setTemplatePath((String)globalAttributes.get("com.tandberg.watchpoint.studio.template"));
        String simulationType = (String)globalAttributes.get(TemplateLauncherConstants.getNodeSimulationTypeKey(nodeName));
        if (simulationType != null && !simulationType.trim().isEmpty()) {
            config.setSimulationType(SimulationType.valueOf(simulationType));
        }
        return config;
    }

    protected SimulationType getDefaultSimulationTypeForNode(NodeElement node) {
        SimulationType result = null;
        result = node instanceof Decision ? SimulationType.EXECUTE : SimulationType.SKIP_NODE;
        return result;
    }

    protected SimulationType getDefaultSimulationTypeForNode(org.jbpm.graph.def.Node node) {
        SimulationType result = null;
        result = node instanceof org.jbpm.graph.node.Decision ? SimulationType.EXECUTE : SimulationType.SKIP_NODE;
        return result;
    }

    protected NodeSimulationConfig getSimulationForNode(org.jbpm.graph.def.Node node, Map globalAttributes, Map<String, Map> attributesPerNode) {
        NodeSimulationConfig config = this.getNodeForSimulation(node.getName(), globalAttributes, attributesPerNode);
        if (config.getSimulationType() == null) {
            config.setSimulationType(this.getDefaultSimulationTypeForNode(node));
        }
        return config;
    }

    public Map<String, NodeSimulationConfig> getNodesForSimulation(ProcessDefinition template, Map globalAttributes) {
        HashMap<String, NodeSimulationConfig> simulationConfigMap = new HashMap<String, NodeSimulationConfig>();
        Map<String, Map> attributesPerNode = NodeSimulationConfigFactory.createSimulationDataMapPerNode(globalAttributes);
        List nodes = template.getNodes();
        for (Object nodeObj : nodes) {
            org.jbpm.graph.def.Node node = (org.jbpm.graph.def.Node)nodeObj;
            NodeSimulationConfig config = this.getSimulationForNode(node, globalAttributes, attributesPerNode);
            simulationConfigMap.put(node.getName(), config);
            if (!(node instanceof Loop)) continue;
            Loop loop = (Loop)node;
            for (Object loopNode : loop.getNodes()) {
                org.jbpm.graph.def.Node innerLoopNode = (org.jbpm.graph.def.Node)loopNode;
                config = this.getSimulationForNode(innerLoopNode, globalAttributes, attributesPerNode);
                simulationConfigMap.put(innerLoopNode.getName(), config);
            }
        }
        return simulationConfigMap;
    }
}

