package com.tandbergtv.watchpoint.studio.builder.resolution.template;

import static com.tandbergtv.watchpoint.studio.ui.model.SemanticElementConstants.VARIABLE_SEID;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMarkerResolution;
import org.jbpm.gd.jpdl.model.StartState;

import com.tandbergtv.watchpoint.studio.builder.resolution.ResolutionMessages;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class LoopNodeWithoutListResolution extends WatchpointStudioTemplateResolution implements IMarkerResolution {

    public LoopNodeWithoutListResolution(IResource resource, Object element) {
        super(resource, element, null);
    }

    @Override
    public String getLabel() {
        return ResolutionMessages.VMC_LN_008;
    }

    @Override
    public void run() {
        try {
            WorkflowTemplate template = getTemplate();

            String variableName = calculateNewVariableName(template, "loopList");
            template.getStartState().getTask().getController()
                    .addVariable(createListVar(template.getStartState(), variableName));

            LoopNode ln = (LoopNode) template.getNodeElementByName((String) element);
            ln.setListName(variableName);

            saveTemplate();
        } catch (CoreException e) {
            Utility.reportError("Error while removing unused variable.", e);
        }
    }

    private WPVariable createListVar(StartState startState, String variableName) {
        WPVariable newIntVariable = (WPVariable) startState.getFactory().createById(VARIABLE_SEID);
        newIntVariable.setType(DataType.LIST.toString());
        newIntVariable.setAccess("read,write");
        newIntVariable.setName(variableName);
        newIntVariable.setMappedName(variableName);
        return newIntVariable;
    }
}
