package com.tandbergtv.watchpoint.studio.builder.resolution.template;


import org.eclipse.core.resources.IResource;
import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.ResolutionConfig;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * Resolution responsible for removing unused variables in the Start Node.
 * @author xpatrpe Patrik Araujo
 * 
 */
public class StartNodeVariableUnusedResolution extends WatchpointStudioTemplateResolution {
	public StartNodeVariableUnusedResolution(IResource resource, Object element, Object message) {
        super(resource, element, message);
    }

    @Override
    public String getLabel() {
        return ResolutionConfig.getInstance().getResolutionMessage("RC-TP-006", element.toString());
    }

    @Override
	public void run() {
		try {
			WorkflowTemplate template = getTemplate();
			
			/* Remove the variable from the template start node */
			String variableName = super.getElement().toString();
			Variable variable = null;
			for (Variable variableItem : template.getStartState().getTask().getController().getVariables()) {
				if(variableName.equals( variableItem.getName() )){
					variable = variableItem;
					break;
				}
			}
			if(variable != null){
				template.getStartState().getTask().getController().removeVariable(variable);
			}

			saveTemplate();
			
		} catch (Exception e) {
			Utility.reportError("Error while removing unused variable.", e);
		}
	}
}
