/*
 * Created on Jun 5, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dto;

/**
 * The ProtectionKey entity
 * 
 * @author Vijay Silva
 */
public class ProtectionKey implements IWatchPointDTO, IPersistable
{
	private static final long serialVersionUID = 4903785147395933396L;

	private long id = DEFAULT_ID;

	private String name;

	/**
	 * Default Constructor
	 */
	public ProtectionKey()
	{
		super();
	}

	/**
	 * Creates a Protection Key object with the given name.
	 * 
	 * @param name
	 * 			The Protection Key Name
	 */
	public ProtectionKey(String name)
	{
		this.name = name;
	}
	
	/**
	 * Constructor
	 * 
	 * @param id
	 *            The Protection Key Id
	 * @param name
	 *            The Protection Key Name
	 */
	public ProtectionKey(long id, String name)
	{
		this.id = id;
		this.name = name;
	}

	/**
	 * Gets the Protection Key Id
	 * 
	 * @see com.tandbergtv.watchpoint.studio.dto.IPersistable#getKey()
	 */
	public Long getKey()
	{
		return this.id;
	}

	/**
	 * @return the id
	 */
	public long getId()
	{
		return this.id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(long id)
	{
		this.id = id;
	}

	/**
	 * @return the name
	 */
	public String getName()
	{
		return this.name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode()
	{
		if (this.id == DEFAULT_ID)
			return super.hashCode();

		return new Long(this.id).hashCode() * 6 - 279;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj)
	{
		if (!(obj instanceof ProtectionKey))
			return false;

		ProtectionKey key = (ProtectionKey) obj;

		/* Check for the Default Id */
		if (this.id == DEFAULT_ID && key.id == DEFAULT_ID)
			return super.equals(key);

		return (this.id == key.id);
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	@Override
	public ProtectionKey clone()
	{
		ProtectionKey clone = null;

		try
		{
			clone = (ProtectionKey) super.clone();
		}
		catch (CloneNotSupportedException ex)
		{ // Should never happen
		}

		return clone;
	}
}
