/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.common.notation.NotationElementFactory;
import org.jbpm.gd.common.notation.NotationMapping;

/**
 * Factory for creation of notational element and their corresponding semantic elements used by the
 * NodeDefinitionEditor.
 * 
 * @author Imran Naqvi
 * 
 */
public class NodeDefinitionCreationFactory implements org.eclipse.gef.requests.CreationFactory {

	String elementId;

	SemanticElementFactory semanticElementFactory;

	NotationElementFactory notationElementFactory;

	public NodeDefinitionCreationFactory(String elementId,
			SemanticElementFactory semanticElementFactory,
			NotationElementFactory notationElementFactory) {
		this.elementId = elementId;
		this.semanticElementFactory = semanticElementFactory;
		this.notationElementFactory = notationElementFactory;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.requests.CreationFactory#getNewObject()
	 */
	public Object getNewObject() {
		String notationElementId = "org.jbpm.gd.jpdl.root";
		NotationElement notationElement = notationElementFactory.create(notationElementId);
		if (notationElement instanceof Node) {
			Dimension dimension = NotationMapping.getInitialDimension(elementId);
			if (dimension != null) {
				Rectangle constraint = ((Node) notationElement).getConstraint();
				constraint.setSize(new Dimension(dimension));
			}
		}
		SemanticElement jpdlElement = semanticElementFactory.createById(elementId);
		notationElement.setSemanticElement(jpdlElement);
		return notationElement;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.requests.CreationFactory#getObjectType()
	 */
	public Object getObjectType() {
		return elementId;
	}

}
