/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.IEditorInput;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.common.part.NodeGraphicalEditPart;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * A graphical edit part which uses edit policies specific to WatchPoint Studio.
 * 
 * @author Imran Naqvi
 *
 */
public abstract class WPNodeGraphicalEditPart extends NodeGraphicalEditPart {

    private static final String DIRECT_EDIT_POLICY = "DirectEditPolicy";
    private IEditorInput editorInput;

    private static final String TRANSPARENT_IMAGE = "transparent.png";
    private static final String BREAKPOINT_IMAGE = "full/obj16/brkp_obj.gif";
    private static ImageRegistry imageRegistry = new ImageRegistry();
    
    static {
        imageRegistry.put(BREAKPOINT_IMAGE, Utility.getImageDescriptor(BREAKPOINT_IMAGE));
        imageRegistry.put(TRANSPARENT_IMAGE, Utility.getImageDescriptor(TRANSPARENT_IMAGE));
    }

	/**
	 * Constructor.
	 */
	public WPNodeGraphicalEditPart(NotationElement notationElement, IEditorInput editorInput) {
		super(notationElement);
		this.editorInput = editorInput;
	}

    /**
	 * @see org.jbpm.gd.common.part.NodeGraphicalEditPart#createEditPolicies()
	 */
	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy(DIRECT_EDIT_POLICY, new WPDirectEditPolicy());
	}

    protected IFigure createFigure() {
        return WPNodeFigureFactory.createFigure((Node)getNotationElement(), imageRegistry.getDescriptor(TRANSPARENT_IMAGE));
    }

    @Override
    public void refreshVisuals() {
        WPHeaderFigure headerFigure = (WPHeaderFigure) ((WPNodeFigure)getFigure()).getChildren().get(0);
        NodeDefinition nodeDefinition = Utility.getNodeDefinition(getNotationElement());
        if (nodeDefinition != null) {
            if (Utility.hasBreakpoint(nodeDefinition, editorInput)) {
                headerFigure.addBreakpoint(imageRegistry.getDescriptor(BREAKPOINT_IMAGE));
            } else {
                headerFigure.removeBreakpoint(imageRegistry.getDescriptor(TRANSPARENT_IMAGE));
            }

            if (nodeDefinition.isHighlight()) {
                headerFigure.addBackgroundHighlight();
            } else {
                headerFigure.removeBackgroundHighlight();
            }
        }

        super.refreshVisuals();
    }

    public void repaintHeader() {
        Figure headerFigure = (Figure) ((WPNodeFigure)getFigure()).getChildren().get(0);
        headerFigure.repaint();
    }
}