package com.tandbergtv.watchpoint.studio.ui.editor.expression;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

public class ExpressionEditorDefaultTooltip extends DefaultToolTip {
    private TableViewer tableViewer;

    public ExpressionEditorDefaultTooltip(TableViewer tableViewer) {
        super(tableViewer.getControl(), ToolTip.NO_RECREATE, false);
        this.tableViewer = tableViewer;
    }

    @Override
    protected boolean shouldCreateToolTip(Event event) {
        ViewerCell cell = tableViewer.getCell(new Point(event.x, event.y));
        if (cell == null || cell.getElement() == null)
            return false;
        WPVariable model = (WPVariable) cell.getElement();
        if (model.getError() != null && (Boolean) ((Object[]) model.getError())[0]
                && cell.getImageBounds().contains(event.x, event.y)) {
            return true;
        }
        return false;
    }

    @Override
    protected String getText(Event event) {
        ViewerCell cell = tableViewer.getCell(new Point(event.x, event.y));
        WPVariable model = (WPVariable) cell.getElement();
        if (model.getError() != null && (Boolean) ((Object[]) model.getError())[0]) {
            return (String) ((Object[]) model.getError())[1];
        }
        return null;
    }
}
