/*
 * Created on Oct 17, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.input;

import org.eclipse.ui.IEditorInput;

/**
 * Marker Interface for all Editor Input objects used by the WatchPoint Editors.
 * 
 * @author Vijay Silva
 */
public interface IWatchPointEditorInput extends IEditorInput
{
	/**
	 * Adds a listener for input changes in this editor input.
	 * 
	 * @param listener
	 *            an input changed listener
	 */
	void addInputChangedListener(IInputChangedListener listener);

	/**
	 * Removes the given input change listener from this editor input. Has no affect if the listener
	 * is not registered.
	 * 
	 * @param listener
	 *            an input changed listener
	 */
	void removeInputChangedListener(IInputChangedListener listener);
}
