/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.model;

import java.util.Set;

import org.jbpm.gd.common.model.SemanticElement;

/**
 * Perent interface of all model elements which can have protection keys.
 * 
 * @author Imran Naqvi
 * 
 */
public interface IProtectionKeyElement extends SemanticElement {

	/**
	 * Adds the protection key to this element's list of protection keys.
	 * 
	 * @param key
	 *            the protection key to add.
	 */
	void addProtectionKey(ProtectionKey key);

	/**
	 * Removes the protection key from this element's list of protection keys.
	 * 
	 * @param key
	 *            the protection key to remove.
	 */
	void removeProtectionKey(ProtectionKey key);

	/**
	 * Gets this element's list of protection keys.
	 * 
	 * @return this element's list of protection keys.
	 */
	Set<ProtectionKey> getProtectionKeys();
}
