package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Image;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

public class AssignNodeLabelProvider extends WPLabelProvider {

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        WPVariable model = (WPVariable) element;
        switch (columnIndex) {
        case 2:
            if (model.getError() != null && ((Object[]) model.getError())[0].equals(Boolean.TRUE)) {
                return getImage(FieldDecorationRegistry.DEC_ERROR);
            } else {
                return getImage(FieldDecorationRegistry.DEC_CONTENT_PROPOSAL);
            }
        }
        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        WPVariable variable = (WPVariable) element;
        switch (columnIndex) {
        case 0:
            return variable.getName();
        case 1:
            return variable.getType();
        case 2:
            return variable.getValue();
        }
        return null;
    }
}