/**
 * RemoveTemplateNodeCommand.java
 * Created Apr 20, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.template;

import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;
import com.tandbergtv.watchpoint.studio.ui.sync.command.AbstractDiffCommand;
import com.tandbergtv.watchpoint.studio.ui.sync.util.ISynchronizationContext;

/**
 * Deletes a node from a template
 * 
 * @author Sahil Verma
 */
public class RemoveTemplateNodeCommand extends AbstractDiffCommand {

	/**
	 * The node that is being removed
	 */
	protected NodeDefinitionDTO node;
	
	/**
	 * Template model
	 */
	protected WorkflowTemplateDTO model;
	
	/**
	 * UI template model
	 */
	protected NodeElementContainer container;
	
	/**
	 * @param name
	 * @param diff
	 * @param context
	 */
	public RemoveTemplateNodeCommand(String name, IDiff diff, ISynchronizationContext context) {
		super(name, diff, context);
		node = (NodeDefinitionDTO) diff.getModel();
	}

	/**
	 * @return the model
	 */
	public WorkflowTemplateDTO getModel() {
		return model;
	}

	/**
	 * @param model the model to set
	 */
	public void setModel(WorkflowTemplateDTO model) {
		this.model = model;
	}

	/**
	 * @return the container
	 */
	public NodeElementContainer getNodeElementContainer() {
		return container;
	}

	/**
	 * @param container the container to set
	 */
	public void setNodeElementContainer(NodeElementContainer container) {
		this.container = container;
	}

	/**
	 * {@inheritDoc}
	 */
	public void execute() {
		updateTemplateGraph();
		updateGPD();
	}

	/**
	 * Modifies the template graph. The node is removed, as are all its inbound transitions.
	 */
	protected void updateTemplateGraph() {
		WorkflowTemplate template = (WorkflowTemplate) container;
		
		for (NodeElement e : template.findNodes(this.node.getId())) {
			container.removeNodeElement(e);
			removeIncomingTransitions(e);
		}
	}
	
	protected void updateGPD() {
		/* FIXME Workaround in WPContentProvider that skips extra nodes in the GPD */
	}
	
	protected void removeIncomingTransitions(NodeElement node) {
		for (NodeElement e : container.getNodeElements()) {
			for (Transition transition : e.getTransitions()) {
				if (node.getName().equals(transition.getTo()))
					e.removeTransition(transition);
			}
		}
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "Template " + model.getName() + ", node " + node.getName() + " " + diff.getKind();
	}
}
