/**
 * ISynchronizationContext.java
 * Created Apr 17, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.util;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.ResourceTypeParameter;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;

/**
 * A sync context to assist during diff reconciliation
 * 
 * @author Sahil Verma
 */
public interface ISynchronizationContext {

	/**
	 * Initializes the context
	 */
	void begin();

	/**
	 * Ends the context. All synchronization operations are completed.
	 */
	void end();

	/**
	 * Aborts the context, rolls back the xaction
	 */
	void abort();
	
	/**
	 * Adds the message
	 * 
	 * @param message
	 */
	void addMessage(Message message);

	/**
	 * Removes the message
	 * 
	 * @param message
	 */
	void deleteMessage(Message message);

	/**
	 * Updates the given message
	 * 
	 * @param message
	 */
	void updateMessage(Message message);

	/**
	 * Creates the given node
	 * 
	 * @param node
	 */
	void createNode(NodeDefinitionDTO node);

	/**
	 * Deletes the given node
	 * 
	 * @param node
	 */
	void deleteNode(NodeDefinitionDTO node);

	/**
	 * Updates the given node
	 * 
	 * @param node
	 */
	void updateNode(NodeDefinitionDTO node);
	
	/**
	 * Merges the given node
	 * 
	 * @param node
	 */
	NodeDefinitionDTO mergeNode(NodeDefinitionDTO node);
	
	/**
	 * Updates the given template
	 * 
	 * @param template
	 */
	void updateTemplate(WorkflowTemplateDTO template);

	/**
	 * Creates the given resource type
	 * 
	 * @param model
	 */
	void createResourceType(ResourceType type);
	
	/**
	 * Updates the given resource type
	 * 
	 * @param type
	 */
	void updateResourceType(ResourceType type);

	/**
	 * @param parameter
	 */
	void deleteParameter(ResourceTypeParameter parameter);
}