package com.tandbergtv.watchpoint.studio.ui.view;

import static com.tandbergtv.watchpoint.studio.ui.model.SemanticElementConstants.TEMPLATE_SEID;
import static com.tandbergtv.watchpoint.studio.ui.util.Utility.TEMPLATE_EDITOR_ID;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.common.xml.XmlAdapter;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.dto.TemplateMessageDTO;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class ResourceTypeMessageReferencesTreeBase extends Dialog {
	protected Button updateReferencesButton;
	private Label changesTreeLabel;
//	private List<IWatchPointDTO> references;
	Map<WorkflowTemplateDTO, List<TemplateMessageDTO>> templateMessagesMap;
	private List<IWatchPointDTO> affectedMessages;
	protected boolean updateReferences;
	protected String messageName;

	private CheckboxTreeViewer treeViewer; 
	
	public ResourceTypeMessageReferencesTreeBase (Shell parentShell) {
		super(parentShell);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
	}
	
	protected Control createControls(Composite parent){
		Composite container = parent;
		
		/* Create update reference button */ 
		Composite checkbox = new Composite(container, SWT.NONE);
		checkbox.setLayoutData( new GridData(GridData.FILL, GridData.FILL, false, false, 2, 1) );
		checkbox.setLayout( new GridLayout(2,true) );
		
		updateReferencesButton = new Button(checkbox,SWT.CHECK);
		updateReferencesButton.setText("Update references");
		updateReferencesButton.setSelection(true);
		updateReferencesButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				//TODO Patrik Implement?
				handleUpdateReferencesButton(event);
			}
		});
		/* Create changes tree label */
		changesTreeLabel = new Label(container, SWT.NONE);
		changesTreeLabel.setText("Changes to be performed :");
		changesTreeLabel.setLayoutData(new GridData(GridData.FILL, GridData.FILL, false, false, 2, 0));
		changesTreeLabel.setVisible(false);
		
		/* Create tree viewer for affected templates */
		createTreeViewer(container);
		
		return container;
		
	}

	private void createTreeViewer(Composite parent){
		// Creates the tree viewer
		treeViewer = new CheckboxTreeViewer(parent);
		treeViewer.getTree().setLayoutData(new GridData(GridData.FILL, GridData.FILL, true, true, 2, 0));
		treeViewer.setContentProvider(new AfectedTemplatesContentProvider());
		treeViewer.setLabelProvider(new AfectedTemplatesLabelProvider());
		
		/* When user checks a checkbox in the tree, check all its children */
		treeViewer.addCheckStateListener(new ICheckStateListener() {
			public void checkStateChanged(CheckStateChangedEvent event) {
				if (event.getChecked()){
					treeViewer.setSubtreeChecked(event.getElement(), true);
				} else {
					treeViewer.setSubtreeChecked(event.getElement(), false);
				}
			}
		});
		treeViewer.getTree();
		treeViewer.setInput("root");
		treeViewer.getTree().setVisible(false);
		setCheckedForAllItems(true);
		
		parent.layout();
	}
	
	public void fillAffectedMessages(){
		affectedMessages = new ArrayList<IWatchPointDTO>();
		for (Object element : treeViewer.getCheckedElements()) {
			if(element instanceof TemplateMessageDTO){
				affectedMessages.add( (IWatchPointDTO)element );
			}
		}
	}
	
	public void initReferences(Map<WorkflowTemplateDTO, List<TemplateMessageDTO>> templateMessagesMap){
		this.templateMessagesMap = templateMessagesMap;
	}
	
	private void handleUpdateReferencesButton(Event event){
		if(event.widget == updateReferencesButton){
			setCheckedForAllItems(updateReferencesButton.getSelection());
		}
	}
	
	protected void showReferencesTree(){
		setDialogSize();
		treeViewer.getTree().setVisible(true);
		
		setCheckedForAllItems(updateReferencesButton.getSelection());
		changesTreeLabel.setVisible(true);
	}
	
	protected void setDialogSize(){
		getShell().setSize(470, 450);
	}
	
	protected void setCheckedForAllItems(boolean check){
		for (Object treeItem : treeViewer.getTree().getItems()) {
			TreeItem rootItem = (TreeItem )treeItem;
			treeViewer.setChecked(rootItem.getData(), check);
			treeViewer.setSubtreeChecked(rootItem.getData(), check);
		} 
	}
	
	
	// ========================================================================
	// ===================== INTERNAL CLASSES FOR TREE VIEWER
	// ========================================================================
	
	private class AfectedTemplatesContentProvider implements ITreeContentProvider{

		@Override
		public void dispose() {
		}

		@Override
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}

		@Override
		public Object[] getElements(Object inputElement) {
			/* The root elements of tree. The templates in this case*/
			if (templateMessagesMap != null){
				return templateMessagesMap.keySet().toArray();
			}
			return new Object[0];
		}

		@Override
		public Object[] getChildren(Object parentElement) {
			/* Return the nodes using the selected message for given template */
			List<TemplateMessageDTO> messages = new ArrayList<TemplateMessageDTO>();
			if(parentElement instanceof WorkflowTemplateDTO){
		    	WorkflowTemplateDTO templateDTO = (WorkflowTemplateDTO)parentElement;
		    	messages.addAll( templateMessagesMap.get(templateDTO));
		    } 
		    return messages.toArray();
		}

		@Override
		public Object getParent(Object element) {
		    return null;
		}

		@Override
		public boolean hasChildren(Object element) {
			if(element instanceof WorkflowTemplateDTO){
		    	return true;
		    } 
		    return false;
		}
		
		protected WorkflowTemplate getTemplateFromFile(String templateFilePath) {
			IFile templateFile = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(templateFilePath));
			
			WorkflowTemplate template = (WorkflowTemplate) new SemanticElementFactory(TEMPLATE_EDITOR_ID).createById(TEMPLATE_SEID);

			SemanticElementFactory factory = new SemanticElementFactory(TEMPLATE_EDITOR_ID);
			XmlAdapter adapter;
			try {
				adapter = Utility.getAdapterFromStream(templateFile.getName(), templateFile.getContents(), factory);
				adapter.initialize(template);
			} catch (CoreException e) {
				e.printStackTrace();
			}
			
			return template;
		}
		
	}
	
	class AfectedTemplatesLabelProvider implements ILabelProvider {

		@Override
		public void addListener(ILabelProviderListener listener) {
		}

		@Override
		public void dispose() {
		}

		@Override
		public boolean isLabelProperty(Object element, String property) {
			return false;
		}

		@Override
		public void removeListener(ILabelProviderListener listener) {
		}

		@Override
		public Image getImage(Object element) {
			return null;
		}

		@Override
		public String getText(Object element) {
			/* Return the labels for the elements in the tree */
		    String text = "";
			if(element instanceof WorkflowTemplateDTO){
		    	WorkflowTemplateDTO templateDTO = (WorkflowTemplateDTO)element;
		    	templateDTO.getMessages();
		    	/* return the template name */
		    	text = templateDTO.getName();
		    }
			
			if(element instanceof TemplateMessageDTO){
				TemplateMessageDTO messageDTO = (TemplateMessageDTO)element;
		    	/* return the template node name */
				text = messageDTO.getTemplateNodeName();
				if(messageDTO.getNodeType().equals(NodeDefinitionType.SuperState)){
					text = text + " (Superstate)";
				}
		    }
		    
			return text;
		}
		
	}
	
	protected void createButtonsForButtonBar(Composite parent) {	 
	}
	
	protected void configureShell(Shell newshell) {
		  super.configureShell(newshell);
		  newshell.setSize(470, 210);
		  newshell.setText("Rename Message Dialog");
	}
	  
	public List<IWatchPointDTO> getAffectedMessages() {
		return affectedMessages;
	}

	public void setAffectedMessages(List<IWatchPointDTO> affectedMessages) {
		this.affectedMessages = affectedMessages;
	}
	
	public boolean getUpdateReferences(){
		return updateReferences;
	}

	public void setMessageName(String messageName) {
		this.messageName = messageName;
	}

	public String getMessageName() {
		return messageName;
	}

}
