/*
 * $HeadURL: $ $Id: $ Copyright (c) 2013 by Ericsson, all rights reserved.
 */

package com.tandbergtv.watchpoint.studio.util;

import org.apache.log4j.Logger;
import org.jbpm.gd.common.model.NamedElement;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.util.ValidationMessages;
import com.tandbergtv.watchpoint.studio.ui.view.DTONameDecorator;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;

/**
 * Util for validation message related feature.
 * 
 * @author Evan Huang
 */
public class ValidationMessageUtil {

    private static final Logger logger = Logger.getLogger(ValidationMessageUtil.class);

    /**
     * Get the validation message according to the input {@link ValidationMessage} object.
     * 
     * @param message
     * @return
     */
    public static String getMessageFromValidationMessage(ValidationMessage message) {
        String msg = message.getCode();

        try {
            msg = ValidationMessages.getInstance().getMessage(message);
            String elementName = "";

            if (message.getElement() instanceof NamedElement) {
                elementName = ((NamedElement) message.getElement()).getName();
            } else if (message.getElement() instanceof ResourceType) {
                elementName = ((ResourceType) message.getElement()).getName();
            } else if (message.getElement() instanceof IWatchPointDTO) {
                elementName = new DTONameDecorator((IWatchPointDTO) message.getElement()).getName();
            } else if (message.getElement() instanceof NodeDefinition) {
                elementName = ((NodeDefinition) message.getElement()).getName();
            }

            if (elementName != null && !elementName.isEmpty()) {
                msg = elementName + " : " + msg;
            }
        } catch (Exception e) {
            logger.warn("Error reading properties", e);
        }

        return msg;
    }
}
