/*
 * Created on Jul 10, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;

/**
 * Indicates an error in the configuration of the validation rules.
 * 
 * @author Vijay Silva
 */
public class ValidationRuleConfiguratonException extends StudioRuntimeException
{
	private static final long serialVersionUID = 1985422376419000394L;

	private Map<Class<?>, List<IValidationRule<?>>> validationRules = new HashMap<Class<?>, List<IValidationRule<?>>>();

	/**
	 * 
	 */
	public ValidationRuleConfiguratonException()
	{
		super();
	}

	/**
	 * @param message
	 *            The detail message.
	 * @param rules
	 *            The map of object types to validation rules that were sucessfully parsed.
	 */
	public ValidationRuleConfiguratonException(String message,
			Map<Class<?>, List<IValidationRule<?>>> rules)
	{
		super(message);
		this.setValidationRules(rules);
	}

	/**
	 * @param message
	 *            The detail message.
	 * @param rules
	 *            The map of object types to validation rules that were sucessfully parsed.
	 * @param cause
	 */
	public ValidationRuleConfiguratonException(String message,
			Map<Class<?>, List<IValidationRule<?>>> rules, Throwable cause)
	{
		super(message, cause);
		this.setValidationRules(rules);
	}

	/**
	 * Get the map of Validation Rules that were successfully parsed. If none were parsed, returns
	 * an empty map.
	 * 
	 * @return the validationRules that were successfully parsed.
	 */
	public Map<Class<?>, List<IValidationRule<?>>> getValidationRules()
	{
		return this.validationRules;
	}

	/**
	 * Set the validation rules that were sucessfully parsed.
	 * 
	 * @param rules
	 *            The validation rules for each object class.
	 */
	void setValidationRules(Map<Class<?>, List<IValidationRule<?>>> rules)
	{
		this.validationRules.clear();

		if (rules != null)
			this.validationRules.putAll(rules);
	}
}
