/*
 * Created on Nov 6, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.nodedefinition;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.NodeNamesUniqueRule;

/**
 * Validates that all the nodes contained a Node Definition have a unique name
 * 
 * @author Vijay Silva
 */
public class NodeDefinitionNodeNamesUniqueRule extends NodeNamesUniqueRule<NodeDefinition>
{
	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.NodeNamesUniqueRule#getDuplicateNodeNameValidationCode()
	 */
	@Override
	protected ValidationMessageCode getDuplicateNodeNameValidationCode()
	{
		return ValidationMessageCode.NODEDEFINITION_NODE_NAME_NOT_UNIQUE;
	}
}
